clear; clc

%add folder path and filename
myfolder='';
filename_sted='actin';
sted_label='Actin';

filename_spt='spt';
spt_label='SPT';

pixelsize=500/187; %in nm

%load file in
%profile_spt=csvread([myfolder,'/',filename_spt,'.csv'],1,0);
%profile_sted=csvread([myfolder,'/',filename_sted,'.csv'],1,0);

profile_spt=csvread([filename_spt,'.csv'],1,0);
profile_sted=csvread([filename_sted,'.csv'],1,0);

%crosscorr
[xcf1,lags,bounds] = crosscorr(profile_spt(:,2),profile_sted(:,2), 'NumLags',length(profile_sted(:,2))-1);
[xcf2,lags2,bounds2] = crosscorr(profile_sted(:,2), profile_spt(:,2), 'NumLags',length(profile_sted(:,2))-1);

xcf=mean([xcf1, xcf2], 2);


%autocorr
auto_spt = autocorr(profile_spt(:,2),length(profile_spt(:,2))-1);
auto_sted= autocorr(profile_sted(:,2),length(profile_sted(:,2))-1);

compixelsize=['pixelsize=', num2str(pixelsize),' ', 'nm'];

array_final = [[1:length(auto_spt)]'*pixelsize,auto_spt, auto_sted, flip(xcf(1:length(auto_spt), :))];


figure(1)
% subplot(1,2,1)
% plot(
% subplot(1,2,2)
plot(array_final(:,1), array_final(:,4),'black');
set(gca,'fontname','arial')
xlabel('Lag (nm)');
ylabel('ACF/XCF');
title({'Crosscorrelation of SPT and actin'});
xlim([0 1000]);
hold on
plot(array_final(:,1), array_final(:,2),'magenta');
hold on
plot(array_final(:,1), array_final(:,3),'cyan');
xline(0);
xticks(0:200:1000)
%xline(190);
%xline(380);
%yline(0);
legend('Crosscorrelation', spt_label, sted_label);
hold off

set(gca,'FontSize', 15)

%save figure to path
saveas(figure(1),fullfile(myfolder,['crosscorrelation','_','XCF_ACF-lag[nm]-plot','_',compixelsize,'.fig']))
saveas(figure(1),fullfile(myfolder,['crosscorrelation','_','XCF_ACF-lag[nm]-plot','_',compixelsize,'.png']))
saveas(figure(1),fullfile(myfolder,['crosscorrelation','_','XCF_ACF-lag[nm]-plot','_',compixelsize,'.pdf']))

%save .csv to path

table_final = array2table(array_final);
table_final.Properties.VariableNames = ["X", "SPT", "STED", "cross"];



writetable(table_final, fullfile(myfolder,['crosscorrelation','_','XCF_ACF-lag[nm]-plot','_',compixelsize,'.csv']));

disp('Done');